/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.aop;

import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.xml.bind.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class CommonExceptionAdvice {
    private static Logger logger = LoggerFactory.getLogger(CommonExceptionAdvice.class);

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseData<Object> handleMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53c2\u6570\u89e3\u6790\u5931\u8d25");
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseData<Object> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53c2\u6570\u89e3\u6790\u5931\u8d25");
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseData<Object> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        logger.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        FieldError error = result.getFieldError();
        String field = error.getField();
        String code = error.getDefaultMessage();
        String message = String.format("%s:%s", field, code);
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25: " + message);
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BindException.class})
    public ResponseData<Object> handleBindException(BindException e) {
        logger.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        FieldError error = result.getFieldError();
        String field = error.getField();
        String code = error.getDefaultMessage();
        String message = String.format("%s:%s", field, code);
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25: " + message);
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseData<Object> handleServiceException(ConstraintViolationException e) {
        logger.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        Set violations = e.getConstraintViolations();
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        String message = violation.getMessage();
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25: " + message);
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={ValidationException.class})
    public ResponseData<Object> handleValidationException(ValidationException e) {
        logger.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        e.getMessage();
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25\uff1a" + e);
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseData<Object> noHandlerFoundException(NoHandlerFoundException e) {
        logger.error("Not Found", (Throwable)e);
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728");
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseData<Object> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        logger.error("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5", (Throwable)e);
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u6b63\u786e");
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseData<Object> handleHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        logger.error("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b", (Throwable)e);
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b");
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BizException.class})
    public ResponseData<Object> handleServiceException(BizException e) {
        logger.error("\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38", (Throwable)e);
        return new ResponseData<Object>(e.getCode(), e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={Exception.class})
    public ResponseData<Object> defaultErrorHandler(Exception e) {
        logger.error("Exception", (Throwable)e);
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53d1\u751f\u5f02\u5e38\uff1a\u672a\u77e5\u9519\u8bef");
        return responseData;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={Throwable.class})
    public ResponseData<Object> defaultErrorHandler(Throwable e) {
        ResponseData<Object> responseData = new ResponseData<Object>();
        responseData.setCode(-1);
        responseData.setMessage("\u53d1\u751f\u5f02\u5e38\uff1a\u672a\u77e5\u9519\u8bef");
        return responseData;
    }
}

