package com.bizvane.utils.enumutils;

import lombok.Getter;


@Getter
public enum IntegralBusinessWayEnum {

    // 10-手动调整获取, 20-手动调整扣减, 30-消费获取积分, 40-退款扣减积分, 50-批量更新获取, 60-批量更新扣减, 70-积分登记获取, 80-会员注册活动, 90-会员升级活动, 100-会员签到活动, 110-会员生日活动, 120-会员消费活动, 130-会员领券活动, 140-积分夺宝活动消耗, 150-积分夺宝活动返还, 160-幸运大转盘消耗, 170-幸运大转盘获取, 180-邀请入会任务, 190-完善资料任务, 200-会员乘机任务, 210-调查问卷任务, 220-积分兑换券扣减, 230-积分兑换商品扣减, 240-积分兑换券退款返还, 250-外部系统扣减, 260-外部系统获取
    MANUAL_ADD(10, "手动调整获取"),
    MANUAL_SUB(20, "手动调整扣减"),
    CONSUME_ADD(30, "消费获取积分"),
    REFUND_SUB(40, "退款扣减积分"),
    BATCH_UPDATE_ADD(50, "批量更新获取"),
    BATCH_UPDATE_SUB(60, "批量更新扣减"),
    REGISTER_ADD(70, "会员注册活动"),
    UPGRADE_ADD(80, "会员升级活动"),
    SIGN_ADD(90, "会员签到活动"),
    BIRTHDAY_ADD(100, "会员生日活动"),
    CONSUME_SUB(120, "会员消费活动"),
    COUPON_ADD(130, "会员领券活动"),
    LUCKY_DRAW_SUB(140, "积分夺宝活动消耗"),
    LUCKY_DRAW_ADD(150, "积分夺宝活动返还"),
    TURNTABLE_SUB(160, "幸运大转盘消耗"),
    TURNTABLE_ADD(170, "幸运大转盘获取"),
    INVITE_ADD(180, "邀请入会任务"),
    PERFECT_ADD(190, "完善资料任务"),
    FLY_ADD(200, "乘机任务"),
    QUESTIONNAIRE_ADD(210, "调查问卷任务"),
    COUPON_SUB(220, "积分兑换券扣减"),
    GOODS_SUB(230, "积分兑换商品扣减"),
    COUPON_REFUND_ADD(240, "积分兑换券退款返还"),
    EXTERNAL_SUB(250, "外部系统扣减"),
    EXTERNAL_ADD(260, "外部系统获取"),
    EXPIRE_SUB(270, "积分过期扣减");

    private Integer type;

    private String typeDes;

    public static CouponValidTypeEnum getType(Integer type) {
        for (CouponValidTypeEnum validType : CouponValidTypeEnum.values()) {
            if (validType.getType().equals(type)) {
                return validType;
            }
        }
        return null;
    }

    IntegralBusinessWayEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDes(Integer type) {
        for (IntegralBusinessWayEnum businessWayEnum : IntegralBusinessWayEnum.values()) {
            if (businessWayEnum.getType().equals(type)) {
                return businessWayEnum.getTypeDes();
            }
        }
        return "未知";
    }
}