package com.bizvane.utils.enumutils;


public enum IntegralMallProductTypeEnum {
    INTEGRAL_COUPON(1, "优惠券商品"),
    INTEGRAL_PRODUCT(2, "实物商品");
    private final Integer type;
    private final String typeDes;
    IntegralMallProductTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallProductTypeEnum deliveryEnum : IntegralMallProductTypeEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
