/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.huaweiutils;

import com.alibaba.fastjson.JSON;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.PutObjectResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"huaweicloud.obs.domain"})
@Component
public class ObsUtil {
    private static final Logger log = LoggerFactory.getLogger(ObsUtil.class);
    @Value(value="${huaweicloud.obs.domain}")
    private String domain;
    @Value(value="${huaweicloud.obs.bucketName}")
    private String bucketName;
    @Value(value="${huaweicloud.obs.accessKey}")
    private String accessKey;
    @Value(value="${huaweicloud.obs.secretKey}")
    private String secretKey;
    private final String endPoint = "obs.cn-south-1.myhuaweicloud.com";

    public ObsClient getObsClient() {
        return new ObsClient(this.accessKey, this.secretKey, "obs.cn-south-1.myhuaweicloud.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadRelativeFile(String objectName, File file) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, file);
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String objectName, File file) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, file);
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadRelativeInputStream(InputStream inputStream, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, inputStream);
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream inputStream, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, inputStream);
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadUrl(String url, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, new URL(url).openStream());
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            log.error("ObsUtil#upload MalformedURLException error:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadRelativeUrl(String url, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, new URL(url).openStream());
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            log.error("ObsUtil#upload MalformedURLException error:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    public Map<String, Object> getCommonFormSignature() {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint("obs.cn-south-1.myhuaweicloud.com");
        config.setAuthType(AuthTypeEnum.OBS);
        ObsClient obsClient = new ObsClient(this.accessKey, this.secretKey, config);
        PostSignatureRequest request = new PostSignatureRequest();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("x-obs-acl", "public-read");
        request.setBucketName(this.bucketName);
        request.setFormParams(formParams);
        request.setExpires(3600L);
        PostSignatureResponse response = obsClient.createPostSignature(request);
        formParams.put("policy", response.getPolicy());
        formParams.put("signature", response.getSignature());
        return formParams;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObsUtil)) {
            return false;
        }
        ObsUtil other = (ObsUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        return !(this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObsUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        return result;
    }

    public String toString() {
        return "ObsUtil(domain=" + this.getDomain() + ", bucketName=" + this.getBucketName() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", endPoint=" + this.getEndPoint() + ")";
    }
}

