package com.bizvane.utils.huaweiutils;

import com.alibaba.fastjson.JSON;
import com.bizvane.utils.fileutils.FileUtil;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.PutObjectResult;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * @author chen.li
 * @date on 2019/11/28 17:14
 * @description 手工操作post华为云obs工具
 */
public class ObsManualUtil {

    private static final String endPoint = "obs.cn-south-1.myhuaweicloud.com";
    private static final String ak = "TYYXUIN65I7OGKGYA0MM";
    private static final String sk = "41Dw7LoFgnezqn7ndIK6QN419Zxx2dLbIz45vR8K";
    private static final String bucketName = "scrm";
    private static final String domain = "scrmobs.skyallhere.com";

    public void setBucketAcl(){
        // 创建ObsClient实例
        ObsClient obsClient = new ObsClient(ak, sk, endPoint);
        // 设置桶访问权限为私有读写
        obsClient.setBucketAcl(bucketName, AccessControlList.REST_CANNED_PRIVATE);
    }

    public static ObsClient getObsClient(){
        // 创建ObsClient实例
        return new ObsClient(ak, sk, endPoint);
    }

    public static String upload(String objectName, File file){
        ObsClient obsClient = null;
        try {
            //获取客户端
            obsClient= getObsClient();
            //上传输入流
            PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectName, file);
            //设置公开只读权限
            obsClient.setObjectAcl(bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            return domain+"/"+objectName;
        } catch (ObsException e) {
            e.printStackTrace();
        }finally{
            // 关闭ObsClient实例，如果是全局ObsClient实例，可以不在每个方法调用完成后关闭
            // ObsClient在调用ObsClient.close方法关闭后不能再次使用
            if(obsClient != null){
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        //要遍历的路径
        String path = "F:\\job\\bizvane\\miniProgram";
        List<File> files = FileUtil.traverseFolder2(path);
        //遍历将小程序静态图片上传，公开可读
//        String key = files.get(0).getPath().replace("F:\\job\\bizvane\\miniProgram\\","").replace("\\","/");
//        System.out.println(upload(key,files.get(0)));
        for(File file:files){
            String key = file.getPath().replace("F:\\job\\bizvane\\miniProgram\\","").replace("\\","/");
            System.out.println(upload(key,file));
        }
    }
}
