package com.bizvane.utils.exception;

import com.bizvane.utils.enumutils.SysResponseEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/*
 * @author Micro
 * @Title: 业务异常
 * @Package ${package_name}
 * @Description: 如果是SEVERE，表示严重错误
 * @date 2018/6/26 20:01
 */
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@Data
public class BizException extends RuntimeException {

    public BizException(String message) {
        this.message = message;
    }
    private int code = SysResponseEnum.FAILED.getCode();

    private String message;



}
