package com.bizvane.utils.sql;

import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.commonutils.SqlCheckUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
@Slf4j
public class TemplateUtil {

    private static final String BIRTHDAY_SQL = "select m.id, m.mbr_members_code, m.card_no, m.name, m.gender, m.phone, m.phone_encrypt, m.email, m.id_card, m.birthday, m.province, m.city, m.county, m.address, m.head_portraits, m.bar_code, m.card_status, m.status_flag, m.open_card_time, mbr_level_def_code, m.extend_ids, m.count_integral, m.remark, m.create_user_code, m.create_user_name, m.create_date, m.modified_user_code, m.modified_user_name, m.modified_date ";

    public static void main(String[] args) {
        String s = "{\"isAnd\":1,\"conditions\":[{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_report_member\",\"fieldName\":\"m.member_gender\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"男\"},{\"code\":\"2\",\"name\":\"女\"},{\"code\":\"3\",\"name\":\"未知\"}],\"datetime\":[],\"dateMap\":{\"type\":\"after\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"男\",\"女\"],\"value\":\"男,女\",\"enumValue\":\"1,2\"}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_report_member\",\"fieldName\":\"m.member_consume_number_all\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"after\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"10\"],\"value\":\"10\",\"enumValue\":\"\"},{\"tableName\":\"t_report_member\",\"fieldName\":\"m.member_consume_number_all\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"LT\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"after\",\"value\":0,\"unit\":\"day\"},\"in\":{},\"selectValues\":[],\"value\":10,\"enumValue\":\"\"},{\"tableName\":\"t_report_member\",\"fieldName\":\"m.member_consume_number_all\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"IN\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"after\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":10,\"val2\":100},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\"}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_report_member\",\"fieldName\":\"m.member_birthday\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"2024-11-14 00:00:00\",\"2024-12-22 23:59:59\"],\"dateMap\":{\"type\":\"after\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\"},{\"tableName\":\"t_report_member\",\"fieldName\":\"m.member_birthday\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BAN\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"after\",\"value\":10,\"unit\":\"day\"},\"in\":{},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\"}]}]}";
        makeupSql(Objects.requireNonNull(JacksonUtil.json2Obj(s, GroupConditionVo.class)));
        System.out.println(getBirthdaySql("1114", "1222", "2024-11-14 00:00:00", "2024-11-19 00:00:00"));
    }

    public static String getBirthdaySql(String birthdayMDStart, String birthdayMDEnd, String openCardTimeStart, String openCardTimeEnd) {
        StringBuilder builder = new StringBuilder();
        builder.append(BIRTHDAY_SQL);
        builder.append(" from t_mbr_members m left join t_mkt_activity_send_record r on m.mbr_members_code = r.mbr_members_code and r.activity_type = 7 ");
        builder.append("and r.create_date >= '").append(DateUtils.formatLocalDateTime(DateUtils.getStartOfYear())).append("'");
        builder.append(" where r.mbr_members_code is null ");
        builder.append(" and m.birthday_md >= '").append(birthdayMDStart).append("'");
        builder.append(" and m.birthday_md <= '").append(birthdayMDEnd).append("'");
        if (StringUtils.isNotBlank(openCardTimeStart)) {
            builder.append(" and m.open_card_time >= '").append(openCardTimeStart).append("'");
        }
        if (StringUtils.isNotBlank(openCardTimeEnd)) {
            builder.append(" and m.open_card_time <= '").append(openCardTimeEnd).append("'");
        }
        return builder.toString();

    }

    public static String makeupSql(GroupConditionVo conditon) {

        validConditions(conditon);

        String sql = deal(conditon);

        if (!SqlCheckUtil.sqlInjection(sql)) {
            throw new RuntimeException("存在SQL注入");
        }
        log.info("group sql:{}", sql);
        return sql;
    }

    private static String deal(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        builder.append(makeupSelect());
        builder.append(" from ");
        builder.append(makeupFrom(conditon));
        builder.append(" where ");
        if (StringUtils.isNotBlank(conditon.getMbrMembersCode())) {
            builder.append(" m.mbr_members_code = '").append(conditon.getMbrMembersCode()).append("' and ");
        }
        builder.append(makeupCondition(conditon));

        String orderBy = makeupOrderBy();
        builder.append(orderBy);

        return builder.toString();
    }

    /**
     * 组装查询表
     */
    private static String makeupFrom(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        List<GroupConditionValueVo> tableList = new ArrayList<>(conditon.getConditions().stream()
                .flatMap(scv -> scv.getSubs().stream()
                        .filter(v -> !v.getTableName().equals("t_mbr_members")) // 排除掉 t_mbr_members
                )
                .collect(Collectors.toMap(
                        GroupConditionValueVo::getTableName, // 使用 tableName 作为键
                        v -> v, // 值为 ValueVo 对象本身
                        (existing, replacement) -> existing // 如果遇到重复，保留第一个
                ))
                .values());

        conditon.getConditions().forEach(scv -> scv.getSubs().forEach(v->
                v.setFieldName(v.getAlias() + "." + v.getFieldName())
        ));

        builder.append(" t_mbr_members m ");
        for (GroupConditionValueVo valueVo : tableList) {

            builder.append(" join ");
            builder.append(valueVo.getTableName()).append(" ").append(valueVo.getAlias());
            builder.append(" on ").append(valueVo.getAlias()).append(".mbr_members_code=m.mbr_members_code");
         }

        return builder.toString();
    }

    /**
     * 组装查询列
     */
    private static String makeupSelect() {
        return " distinct m.id, m.mbr_members_code, m.card_no, m.name, m.gender, m.phone, m.phone_encrypt, m.email, m.id_card, m.birthday, m.province, m.city, m.county, m.address, m.head_portraits, m.bar_code, m.card_status, m.status_flag, m.open_card_time, mbr_level_def_code, m.extend_ids, m.count_integral, m.remark, m.create_user_code, m.create_user_name, m.create_date, m.modified_user_code, m.modified_user_name, m.modified_date";
    }

    /**
     * 组装条件
     */
    private static String makeupCondition(GroupConditionVo conditon) {

        List<String> subs = new ArrayList<>();

        for (GroupConditionSubVo scv : conditon.getConditions()) {
            int cnt = scv.getSubs().size();
            List<String> conditions = new ArrayList<>();
            for (int i = 0; i < cnt; i++) {
                conditions.add(getCondition(scv.getSubs().get(i)));
            }
            if (scv.getIsAnd().intValue() == 1) {
                subs.add(String.format("(%s)", String.join(" and ", conditions)));
            } else if (scv.getIsAnd().intValue() == 2) {
                subs.add(String.format("(%s)", String.join(" or ", conditions)));
            }
        }

        if (conditon.getIsAnd() == 1) {
            return String.join(" and ", subs);
        } else if (conditon.getIsAnd() == 2) {
            return String.join(" or ", subs);
        }
        return "1=1";
    }

    private static String getCondition(GroupConditionValueVo valueVo) {
        if (valueVo.getFieldDataType().toUpperCase().equals("DATETIME")) {
            return getDateCondition(valueVo);
        } if (valueVo.getFieldDataType().toUpperCase().equals("STRING")) {
            return getStringCondition(valueVo);
        } else if (valueVo.getFieldDataType().toUpperCase().equals("DECIMAL")) {
            return getDecimalCondition(valueVo);
        } else if (valueVo.getFieldDataType().toUpperCase().equals("ARRAY")) {
            return getArrayCondition(valueVo);
        }

        return "";
    }

    private static String makeupOrderBy() {

        return " Order by m.id asc";
    }

    private static String getArrayCondition(GroupConditionValueVo valueVo) {
        if (StringUtils.isNotEmpty(valueVo.getValue())) {
            String[] vals = valueVo.getValue().split(",");
            // String val = StringUtils.join(vals, "','");

            List<String> ors = new ArrayList<>();
            for (String val : vals) {
                ors.add(String.format("instr(array_join(%s, '$'),'%s')>0 ", valueVo.getFieldName(), val));
            }

            return "(" + String.join(" or ", ors) + ")";
        }

        return "1=1";
    }

    private static String getFieldCondition(GroupConditionValueVo valueVo) {
        List<String> cons = new ArrayList<>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        for (String val : vals) {
            cons.add(fieldName + operator + val);
        }

        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join(" and ", cons));
        } else {
            return String.format("( %s )", String.join(" or ", cons));
        }
    }

    private static String getStringCondition(GroupConditionValueVo valueVo) {
        List<String> cons = new ArrayList<>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        List<String> results = new ArrayList<>();
        for (String val : vals) {
            cons.add(fieldName + operator + String.format("'%s'", val));
            if (valueVo.getFieldDataType().equals("DECIMAL")) {
                results.add(String.format("%s", val));
            } else {
                results.add(String.format("'%s'", val));
            }
        }

        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s in (%s)", fieldName, String.join(",", results));
        } else if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals((OperatorEnum.EQUAL.getCode()))) {
                return String.format("%s in (%s)", fieldName, String.join(",", results));
            } else if (valueVo.getMatch().getOperator().equals((OperatorEnum.NOTEQUAL.getCode()))) {
                return String.format("%s not in (%s)", fieldName, String.join(",", results));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        } else {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("( %s )", String.join(" and ", cons));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        }
    }

    private static String getDecimalCondition(GroupConditionValueVo valueVo) {
        List<String> cons = new ArrayList<>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        List<String> results = new ArrayList<>();
        for (String val : vals) {
            cons.add(fieldName + operator + val);
            results.add(String.format("%s", val));
        }

        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            if (results.size() == 2) {
                return String.format("%s>=%s and %s<=%s", fieldName, results.get(0), fieldName, results.get(1));
            } else {
                return String.format("%s in (%s)", fieldName, String.join(",", results));
            }
        } else if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals((OperatorEnum.EQUAL.getCode()))) {
                return String.format("%s in (%s)", fieldName, String.join(",", results));
            } else if (valueVo.getMatch().getOperator().equals((OperatorEnum.NOTEQUAL.getCode()))) {
                return String.format("%s not in (%s)", fieldName, String.join(",", results));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        } else {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("( %s )", String.join(" and ", cons));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        }
    }

    private static String getDateCondition(GroupConditionValueVo valueVo) {
        String fieldName = valueVo.getFieldName();
        GroupConditionDateVo dateMap = valueVo.getDateMap();

        if (OperatorEnum.BETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        } else if (OperatorEnum.NOTBETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " not between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        } else if (valueVo.getMatch().getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode())) {
            if ("before".equals(dateMap.getType())) {
                return fieldName + " < '" + getDateFormat(dateMap.getUnit(), dateMap.getValue()) + "'";
            } else if ("after".equals(dateMap.getType())) {
                return fieldName + " > '" + getDateFormat(dateMap.getUnit(), -dateMap.getValue()) + "'";
            }
        }
        return "1=1";
    }

    private static String getDateFormat(String unit, Integer value) {
        if ("day".equals(unit)) {
            return DateUtils.formatYYYYMMDDHHmmSS(DateUtils.getSpecifiedDayBefore(new Date(), value));
        } else if ("hour".equals(unit)) {
            return DateUtils.formatYYYYMMDDHHmmSS(DateUtils.getSpecifiedHourBefore(new Date(), value));
        } else if ("minute".equals(unit)) {
            return DateUtils.formatYYYYMMDDHHmmSS(DateUtils.getSpecifiedMinuteBefore(new Date(), value));
        } else {
            throw new RuntimeException("时间单位错误");
        }
    }

    private static void validConditions(GroupConditionVo condition) {
        if (condition != null && !CollectionUtils.isEmpty(condition.getConditions())) {

            validArgNegative(condition.getIsAnd(), "isAnd属性");

            for (GroupConditionSubVo sub : condition.getConditions()) {

                validArgNegative(sub.getIsAnd(), "isAnd属性");

                if (!CollectionUtils.isEmpty(sub.getSubs())) {
                    for (GroupConditionValueVo vv : sub.getSubs()) {
                        validArgNull(vv.getFieldName(), "字段名称");
                        validArgNull(vv.getFieldDataType(), "字段类型");
                        if (vv.getMatch() == null) {
                            throw new RuntimeException("条件操作不能为空");
                        }
                        validMatch(vv.getMatch());

                        if (vv.getFieldDataType().toUpperCase().equals("DECIMAL")) {
                            if (StringUtils.isNotEmpty((vv.getValue()))) {
                                String[] vals = vv.getValue().split(",");
                                validDecimal(vals, StringUtils.isNotEmpty(vv.getChnName()) ? vv.getChnName() : vv.getFieldName());
                            }
                        } else if (vv.getFieldDataType().toUpperCase().equals("STRING")) {
                            if (StringUtils.isNotEmpty((vv.getValue()))) {
                                if (!SqlCheckUtil.formFieldDataSqlInjection(vv.getValue())) {
                                    throw new RuntimeException("传入条件存在SQL注入风险");
                                }
                            }
                        } else if (vv.getFieldDataType().toUpperCase().equals("DATETIME")) {
                            validDate(vv.getMatch(), vv.getDateMap(), vv.getDatetime());
                        }

                    }
                } else {
                    throw new RuntimeException("子组条件不能为空");
                }
            }

        }
    }

    private static void ValidInjection(String[] vals) {
        boolean existStart = false;
        boolean existEnd = false;
        for (String val : vals) {
            int cnt = countString(val.trim(), "'");
            if (cnt == 1) {
                existStart = true;
            }
            if (cnt != 1) {
                if (cnt % 2 != 0) {
                    existEnd = true;
                }
            }
        }

        if (existStart && existEnd) {
            throw new RuntimeException("传入条件存在SQL注入");
        }
    }

    private static int countString(String str, String s) {
        int count = 0, len = str.length();
        while (str.indexOf(s) != -1) {
            str = str.substring(str.indexOf(s) + 1, str.length());
            count++;
        }
        return count;
    }

    private static void validDecimal(String[] vals, String fieldName) {
        for (String val : vals) {
            if (StringUtils.isNotEmpty(val)) {
                try {
                    new BigDecimal(val);
                } catch (Exception e) {
                    throw new RuntimeException("条件字段:" + fieldName + "是数值型字段,不能输入非数值型的值");
                }
            } else {
                throw new RuntimeException("条件字段:" + fieldName + "未赋值");
            }
        }
    }


    private static void validDate(TableDictVO.MatchVo match, GroupConditionDateVo vo, List<String> datetime) {
        if (match.getOperator().equals(OperatorEnum.BETWEEN.getCode())) {
            if (CollectionUtils.isEmpty(datetime)) {
                throw new RuntimeException("时间(select属性)未设置");
            }
        }
        if (match.getOperator().equals(OperatorEnum.NOTBETWEEN.getCode())) {
            if (CollectionUtils.isEmpty(datetime)) {
                throw new RuntimeException("时间(select属性)未设置");
            }
        } else if (match.getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode())) {
            if (StringUtils.isBlank(vo.getType()) || StringUtils.isBlank(vo.getUnit()) || vo.getValue() == null) {
                throw new RuntimeException("时间(select属性)2未设置");
            }
        }
    }


    private static void validMatch(TableDictVO.MatchVo match) {
        validArgNull(match.getOperator(), "比较方式代码");
        //  validArgNull(match.getName(), "比较方式名称");
        if (!SqlOperatorUtil.contains(match.getOperator())) {
            throw new RuntimeException("比较方式代码" + match.getOperator() + "设置错误");
        }
    }
    private static void validArgNull(String value, String msg) {
        if (StringUtils.isEmpty((value))) {
            throw new RuntimeException(msg + "不能为空");
        }
    }

    private static void validArgNegative(Integer value, String msg) {
        if (value == null || value.intValue() < 1) {
            throw new RuntimeException(msg + "不能为空");
        }
    }
}
