/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackSensitiveDataFilter
extends Filter<ILoggingEvent> {
    private Level level;
    private static final Pattern PHONE_PATTERN_REGEX_1 = Pattern.compile("\"phone\"\\s*:\\s*\"(\\d{3})(\\d{4})(\\d{4})\"");
    private static final Pattern PHONE_PATTERN_REGEX_2 = Pattern.compile("\\\\\"phone\\\\\"\\s*:\\s*\\\\\"(\\d{3})(\\d{4})(\\d{4})\\\\\"");
    private static final Pattern PHONE_PATTERN_REGEX_3 = Pattern.compile("phone=(\\d{3})(\\d{4})(\\d{4})");

    public FilterReply decide(ILoggingEvent event) {
        String message = event.getFormattedMessage();
        Matcher matcher1 = PHONE_PATTERN_REGEX_1.matcher(message);
        Matcher matcher2 = PHONE_PATTERN_REGEX_2.matcher(message);
        Matcher matcher3 = PHONE_PATTERN_REGEX_3.matcher(message);
        if (matcher1.find() || matcher2.find() || matcher3.find()) {
            if (matcher1.find()) {
                message = this.maskPhoneNumberRegex1(message);
            }
            if (matcher2.find()) {
                message = this.maskPhoneNumberRegex2(message);
            }
            if (matcher3.find()) {
                message = this.maskPhoneNumberRegex3(message);
            }
            this.logSanitizedMessage(event, message);
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    private String maskPhoneNumberRegex1(String message) {
        return PHONE_PATTERN_REGEX_1.matcher(message).replaceAll("\"phone\":\"$1****$3\"");
    }

    private String maskPhoneNumberRegex2(String message) {
        return PHONE_PATTERN_REGEX_2.matcher(message).replaceAll("\\\\\"phone\\\\\":\\\\\"$1****$3\\\\\"");
    }

    private String maskPhoneNumberRegex3(String message) {
        return PHONE_PATTERN_REGEX_3.matcher(message).replaceAll("phone=$1****$3");
    }

    private void logSanitizedMessage(ILoggingEvent event, String sanitizedMessage) {
        Logger logger = LoggerFactory.getLogger((String)event.getLoggerName());
        switch (event.getLevel().levelInt) {
            case 40000: {
                logger.error(sanitizedMessage);
                break;
            }
            case 30000: {
                logger.warn(sanitizedMessage);
                break;
            }
            case 20000: {
                logger.info(sanitizedMessage);
                break;
            }
            case 10000: {
                logger.debug(sanitizedMessage);
                break;
            }
            case 5000: {
                logger.trace(sanitizedMessage);
                break;
            }
            default: {
                logger.info(sanitizedMessage);
            }
        }
    }

    public void setLevel(String level) {
        this.level = Level.toLevel((String)level);
    }

    public void start() {
        if (this.level != null) {
            super.start();
        }
    }
}

