package com.bizvane.utils.enumutils;


public enum IntegralMallMbrRangeTypeEnum {
    INTEGRAL_COUPON(1, "全部会员"),
    INTEGRAL_PRODUCT(2, "会员等级");
    private final Integer type;
    private final String typeDes;
    IntegralMallMbrRangeTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallMbrRangeTypeEnum deliveryEnum : IntegralMallMbrRangeTypeEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
