package com.bizvane.utils.enumutils;

import lombok.Getter;

/**
 * 会员卡状态
 */
@Getter
public enum IntegralMallOrderStatusEnum {
    //订单状态 0待付款 1已付款/待发货/待自提 2已发货（实物） 3已签收/已自提（实物）4已完成 5已退货 6已取消
    WAIT_PAY(0, "待付款"),
    WAIT_DELIVERY(1, "已付款/待发货/待自提"),
    DELIVERY(2, "已发货（实物）"),
    SIGN(3, "已签收/已自提（实物）"),
    SUCCESS(4, "已完成"),
    REFUNDING(5, "已退货"),
    CLOSE(6, "已取消");

    private final Integer type;

    private final String typeDes;

    IntegralMallOrderStatusEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
}