/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisClient {
    @Resource
    private RedisTemplate<Serializable, Object> redisTemplate;

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

