/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelImportUtil {
    public List<List<String>> parseExcel(String filePath) throws IOException {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        FileInputStream fis = new FileInputStream(new File(filePath));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
        Sheet sheet = workbook.getSheetAt(0);
        for (Row row : sheet) {
            ArrayList<String> rowData = new ArrayList<String>();
            block7: for (Cell cell : row) {
                switch (cell.getCellType()) {
                    case STRING: {
                        rowData.add(cell.getStringCellValue());
                        continue block7;
                    }
                    case NUMERIC: {
                        rowData.add(String.valueOf(cell.getNumericCellValue()));
                        continue block7;
                    }
                    case BOOLEAN: {
                        rowData.add(String.valueOf(cell.getBooleanCellValue()));
                        continue block7;
                    }
                    case FORMULA: {
                        rowData.add(cell.getCellFormula());
                        continue block7;
                    }
                }
                rowData.add("");
            }
            data.add(rowData);
        }
        workbook.close();
        fis.close();
        return data;
    }
}

