/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.code;

import com.alibaba.fastjson.JSONObject;
import com.spire.barcode.BarCodeGenerator;
import com.spire.barcode.BarcodeSettings;
import com.spire.barcode.IBarCodeSettings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeUtils {
    private static Logger logger = LoggerFactory.getLogger(BarcodeUtils.class);
    private static final String FORMAT_NAME = "png";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateBarCode(String code) {
        logger.info("enter BarcodeUtil generateBarCode param:msg:{}", (Object)code);
        BarcodeSettings settings = new BarcodeSettings();
        settings.setType(9L);
        settings.setData(code);
        settings.setShowText(false);
        settings.setShowTextOnBottom(false);
        settings.hasBorder(false);
        BarCodeGenerator barCodeGenerator = new BarCodeGenerator((IBarCodeSettings)settings);
        BufferedImage image = barCodeGenerator.generateImage();
        ByteArrayOutputStream os = null;
        String resultImage = null;
        try {
            os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, FORMAT_NAME, os);
            resultImage = new String("data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray()));
        }
        catch (Exception e) {
            logger.info("enter BarcodeUtil generateBarCode Exception:e:{}", (Object)JSONObject.toJSONString((Object)e));
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return resultImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateQRCode(String code) {
        logger.info("enter BarcodeUtil generateQRCode param:msg:{}", (Object)code);
        BarcodeSettings settings = new BarcodeSettings();
        settings.setType(24L);
        settings.setData(code);
        settings.setShowText(false);
        settings.setQRCodeDataMode(2);
        settings.setX(2.5f);
        settings.setY(2.5f);
        settings.setQRCodeECL(3);
        settings.hasBorder(false);
        settings.setData2D(null);
        settings.setShowTopText(false);
        settings.setShowText(false);
        settings.setBottomMargin(0.0f);
        settings.setTopMargin(0.0f);
        settings.setLeftMargin(0.0f);
        settings.setRightMargin(0.0f);
        BarCodeGenerator barCodeGenerator = new BarCodeGenerator((IBarCodeSettings)settings);
        BufferedImage image = barCodeGenerator.generateImage();
        ByteArrayOutputStream os = null;
        String resultImage = null;
        try {
            os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, FORMAT_NAME, os);
            resultImage = new String("data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray()));
            os.close();
        }
        catch (Exception e) {
            logger.info("enter BarcodeUtil generateQRCode Exception:e:{}", (Object)JSONObject.toJSONString((Object)e));
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return resultImage;
    }
}

