package com.bizvane.utils.enumutils;

/**
 * @author chen.li
 * @date on 2018/6/21 10:30
 * @description 系统响应返回码枚举类，此处定义所有该系统对外响应的返回码及释义
 * @version 1.0
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public enum SysResponseEnum {
    SUCCESS(0, "操作成功！"),
    FAILED(-1, "操作失败！"),
    NULLPOINTEREXCEPTION(-1000, "空指针异常"),

    // 数据验证相关（500系列）
    MODEL_FAILED_VALIDATION(500, "数据验证不通过"),

    // 操作错误相关（100系列）
    OPERATE_FAILED_DATA_NOT_EXISTS(101, "查询数据不存在！"),
    OPERATE_FAILED_ADD_ERROR(102, "新增数据失败！"),
    OPERATE_FAILED_UPDATE_ERROR(103, "更新数据失败！"),
    OPERATE_FAILED_FILE_NOT_EXISTS(104, "操作失败，文件不存在！"),
    OPERATE_FAILED_FILE_UPLOAD_ERROR(105, "操作失败，文件上传错误！"),

    // 用户登录相关（200系列）
    USER_LOGIN_FAILED_VALIDATECODE_NOT_EXISTS(201, "验证码不存在！"),
    USER_LOGIN_FAILED_VALIDATECODE_ERROR(202, "验证码错误！"),
    USER_LOGIN_SMS_CODE_OVERTIME(203, "短信验证码已过期！"),
    USER_LOGIN_FAILED_USERID_NOT_EXISTS(204, "登录失败，用户名不存在！"),
    USER_BIND_THIRD_LOGIN_ERROR(205, "登录失败，用户被禁用！"),
    USER_LOGIN_FAILED_USER_DISABLE(206, "登录失败，密码错误！"),
    USER_UPDATE_ERROR(207, "修改用户失败！"),
    USER_MIBILE_NOT_EXIST(208, "该手机号不存在！"),

    // 网络与系统错误（300系列）
    NETWORK_ERROR(301, "网络异常！"),
    SYSTEM_ERROR(302, "系统内部错误！"),

    // 上传相关（400系列）
    UPLOAD_SUCCESS(401, "导入成功！"),
    UPLOAD_FAILED(402, "导入失败！"),

    // 参数相关（1000系列）
    PARAM_NULL(1001, "入参为空"),
    PARAM_INVALID(1002, "参数校验失败"),
    PARAM_OUT_OF_RANGE(1003, "参数超出范围"),
    PARAM_FORMAT_ERROR(1004, "参数格式错误"),

    // 会员相关（2000系列）
    MEMBER_NOT_FOUND(2001, "会员不存在"),
    MEMBER_ALREADY_EXISTS(2002, "会员已经存在"),
    MEMBER_INACTIVE(2003, "会员账户已被禁用"),

    // 优惠券相关（3000系列）
    COUPON_NOT_FOUND(3001, "优惠券不存在"),
    COUPON_EXPIRED(3002, "优惠券已过期"),
    COUPON_NOT_APPLICABLE(3003, "优惠券不适用于该订单"),
    COUPON_LIMIT_REACHED(3004, "优惠券使用次数达到上限"),
    COUPON_NOT_VALID_CURRENT_MERCHANT(3005, "优惠券不适用于当前商户"),

    // 积分相关（4000系列）
    POINTS_NOT_FOUND(4001, "积分记录不存在"),
    INSUFFICIENT_POINTS(4002, "积分不足"),
    POINTS_EXPIRED(4003, "积分已过期"),

    // 订单相关（5000系列）
    ORDER_NOT_FOUND(5001, "订单不存在"),
    ORDER_ALREADY_PAID(5002, "订单已经支付"),
    ORDER_CANCELLATION_NOT_ALLOWED(5003, "订单无法取消"),
    ORDER_STATUS_INVALID(5004, "订单状态无效"),

    // 商品相关（6000系列）
    PRODUCT_NOT_FOUND(6001, "商品不存在"),
    INSUFFICIENT_STOCK(6002, "库存不足"),
    POINTS_REDEMPTION_FAILED(6003, "积分兑换失败"),

    // 营销活动相关（7000系列）
    CAMPAIGN_NOT_FOUND(7001, "营销活动不存在"),
    CAMPAIGN_NOT_ACTIVE(7002, "营销活动未开始或已结束"),
    CAMPAIGN_LIMIT_REACHED(7003, "营销活动已达到参与上限"),

    // 营销任务相关（8000系列）
    TASK_NOT_FOUND(8001, "营销任务不存在"),
    TASK_ALREADY_COMPLETED(8002, "营销任务已完成"),
    TASK_NOT_QUALIFIED(8003, "不符合营销任务参与条件"),

    // 营销游戏相关（9000系列）
    GAME_NOT_FOUND(9001, "营销游戏不存在"),
    GAME_NOT_ACTIVE(9002, "营销游戏未开始或已结束"),
    GAME_PARTICIPATION_ERROR(9003, "参与游戏出错"),

    // 中台账号相关（10000系列）
    ACCOUNT_NOT_FOUND(10001, "中台账号不存在"),
    ACCOUNT_ALREADY_EXISTS(10002, "中台账号已经存在"),
    ACCOUNT_INACTIVE(10003, "中台账号已被禁用"),

    // 中台批量任务相关（11000系列）
    BATCH_TASK_NOT_FOUND(11001, "批量任务不存在"),
    BATCH_TASK_ALREADY_RUNNING(11002, "批量任务正在运行"),
    BATCH_TASK_FAILED(11003, "批量任务执行失败");

    private int code;

    private String message;

    SysResponseEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

} 

