package com.bizvane.utils.enumutils;

public enum PaymentType {
    FREE_COUPON(1, "免费券"),           // 免费券
    POINTS_REDUCTION(2, "积分抵现"),     // 积分抵现
    MALL_COUPON(3, "商场券"),           // 商场券
    CASH_COUPON(4, "现金券"),           // 现金券
    STORED_VALUE_CARD(5, "储值卡"),      // 储值卡
    BANK_CARD(6, "银行卡"),             // 银行卡
    WECHAT(7, "微信"),                   // 微信
    ALIPAY(8, "支付宝"),                 // 支付宝
    CASH(9, "现金"),                    // 现金
    OTHER(0, "其他方式");               // 其他方式

    private final int type;       // 支付类型的值
    private final String typeDesc; // 支付类型的描述

    PaymentType(int type, String typeDesc) {
        this.type = type;
        this.typeDesc = typeDesc;
    }

    public int getType() {
        return type;
    }

    public String getTypeDesc() {
        return typeDesc;
    }

    // 根据支付类型的值获取描述
    public static String getDescriptionByType(int paymentType) {
        for (PaymentType pt : values()) {
            if (pt.type == paymentType) {
                return pt.typeDesc;
            }
        }
        return "未知支付方式"; // 默认情况
    }
}
