package com.bizvane.utils.enumutils;

public enum PaymentFrozenRecordSliptStatusEnum {
    PAY_FROZEN_RECORD_SLIPT_WAIT(0, "未处理"),
    PAY_FROZEN_RECORD_SLIPT_SUCCESS(1, "分账成功"),
    PAY_FROZEN_RECORD_SLIPT_FAIL(2, "分账失败");

    private Integer code;
    private String desc;

    PaymentFrozenRecordSliptStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentFrozenRecordSliptStatusEnum getByCode(Integer code) {
        for (PaymentFrozenRecordSliptStatusEnum value : PaymentFrozenRecordSliptStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }


}
