package com.bizvane.utils.enumutils;

import lombok.Getter;

@Getter
public enum CouponTypeEnum {
    /** 通用券 */
    NORMAL("0", "通用券"),

    /** 安检服务券 */
    SECURITY_CHECK("10", "安检服务券"),

    /** 行李打包券 */
    LUGGAGE_PACKING("20", "行李打包券"),

    /** 行李寄存券 */
    LUGGAGE_STORAGE("30", "行李寄存券"),

    /** 车辆充电券 */
    VEHICLE_CHARGING("40", "车辆充电券"),

    /** 贵宾服务券 */
    VIP_SERVICE("50", "贵宾服务券"),

    /** 电瓶车服务券 */
    ELECTRIC_CART("60", "电瓶车服务券"),

    /** 订餐服务券 */
    MEAL_ORDERING("70", "订餐服务券"),

    /** 零售服务券 */
    RETAIL_SERVICE("80", "零售服务券"),

    /** 餐饮服务券 */
    CATERING_SERVICE("90", "餐饮服务券"),

    /** 航延服务券 */
    FLIGHT_DELAY("100", "航延服务券"),

    /** 停车服务券 */
    PARKING_SERVICE("110", "停车服务券"),

    /** 租车服务券 */
    CAR_RENTAL("120", "租车服务券"),

    /** 门到门服务券 */
    DOOR_TO_DOOR("130", "门到门服务券"),

    /** 快递服务券 */
    EXPRESS_SERVICE("140", "快递服务券"),

    /** 巴士服务券 */
    BUS_SERVICE("150", "巴士服务券");

    private String type;

    private String typeDes;

    CouponTypeEnum(String type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }

    public static CouponTypeEnum getType(String type) {
        for (CouponTypeEnum validType : CouponTypeEnum.values()) {
            if (validType.getType().equals(type)) {
                return validType;
            }
        }
        return null;
    }

    public static String getDes(String type) {
        for (CouponTypeEnum sendTypeEnum : CouponTypeEnum.values()) {
            if (sendTypeEnum.getType().equals(type)) {
                return sendTypeEnum.getTypeDes();
            }
        }
        return "未知";
    }
}


