package com.bizvane.utils.enumutils;

public enum PaymentPayChannelTypeEnum {

    WEIXIN_TYPE("WEIXIN_TYPE", "微信支付通道"),
    ICBC_TYPE("ICBC_TYPE", "工商支付通道");

    private String code;
    private String desc;

    PaymentPayChannelTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentPayChannelTypeEnum getByCode(String code) {
        for (PaymentPayChannelTypeEnum value : PaymentPayChannelTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
