package com.bizvane.utils.enumutils;

public enum PaymentFrozenRecordStatusEnum {
    PAY_FROZEN_RECORD_FROZEN(1, "冻结"),
    PAY_FROZEN_RECORD_UNSLIPT(2, "待分账"),
    PAY_FROZEN_RECORD_SLIPT_SUCCESS(3, "已分账");

    private Integer code;
    private String desc;

    PaymentFrozenRecordStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentFrozenRecordStatusEnum getByCode(Integer code) {
        for (PaymentFrozenRecordStatusEnum value : PaymentFrozenRecordStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }


}
