package com.bizvane.utils.enumutils;

public enum PaymentPayTypeEnum {
    WEIXIN("WEIXIN", "微信支付"),
    ALIPAY("ALIPAY", "支付宝支付");

    private String code;
    private String desc;

    PaymentPayTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentPayTypeEnum getByCode(String code) {
        for (PaymentPayTypeEnum value : PaymentPayTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

}
