package com.bizvane.utils.sql;

import java.util.concurrent.ConcurrentHashMap;

public class SqlOperatorUtil {

//    EQUAL("EQ","等于"),
//
//    NOTEQUAL("NEQ","不等于"),
//
//    MORETHAN("MT","大于"),
//
//    LESSTHAN("LT","小于"),
//
//    MOREOREQUAL("MOE","大于等于"),
//
//    LESSOREQUAL("LOE","小于等于"),
//
//    LIKE("LK","匹配"),
//
//    RANGE("IN","范围"),
//
//    BETWEEN("BT","固定时间范围"),
//
//    NOTBETWEEN("NBT","不在固定时间范围"),
//
//    BEFOREORAFTERNOW("BAN","在当前时间");


    private static ConcurrentHashMap<String, String> operatorDict = new ConcurrentHashMap<>();

    static {
        operatorDict.put("EQ", "=");
        operatorDict.put("NEQ", "!=");
        operatorDict.put("MT", ">");
        operatorDict.put("LT", "<");
        operatorDict.put("MOE", ">=");
        operatorDict.put("LOE", "<=");
        operatorDict.put("LK", "like");
        operatorDict.put("IN", "=");
        operatorDict.put("BT", "between '%s' and '%s'");
        operatorDict.put("NBT", "not between '%s' and '%s'");
        operatorDict.put("BAN", "between %s and %s");
    }

    private SqlOperatorUtil() {

    }

    public static String getOperator(String code) {

        if (operatorDict.containsKey(code)) {
            return operatorDict.get(code);
        }
        return "=";
    }

    public static boolean contains(String code) {
        return operatorDict.containsKey(code);
    }
}
