package com.bizvane.utils.commonutils;

import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.function.Function;

public class ObjectUtil {

    public static <T, V> V getByMap(Map<String, T> data, String key, Function<T, V> first, V defaultValue) {
        if (data == null || StringUtils.isBlank(key) || !data.containsKey(key)) {
            return defaultValue;
        }
        return first.apply(data.get(key));
    }
}
