package com.bizvane.utils.enumutils;

public enum PaymentTradeStatusEnum {
    PAY_WAIT(0, "待支付"),
    PAY_SUCCESS(1, "支付成功"),
    PAY_CLOSE(2, "支付关闭"),
    PAY_REFUND(3, "支付退款");

    private Integer code;
    private String desc;

    PaymentTradeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentTradeStatusEnum getByCode(Integer code) {
        for (PaymentTradeStatusEnum value : PaymentTradeStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }


}
