package com.bizvane.utils.enumutils;

import lombok.Getter;

/**
 * 中台登录鉴权枚举
 */
@Getter
public enum AuthResponseEnum {

    UN_LOGIN(-2, "未登录"),
    UN_AUTH(-3, "缺少权限"),
    UN_ROLE(-4, "缺少角色"),
    LOGIN_FAIL(-5, "登录名或密码错误"),
    SIGN_FAIL(-6, "请求非法"),
    ;
    private final Integer code;
    private final String value;

    AuthResponseEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

}
