package com.bizvane.utils.enumutils;

public enum PaymentFlowOperationTypeEnum {
    PAY_CREATE("PAY_CREATE", "创建支付"),
    PAY_NOTIFY("PAY_NOTIFY", "支付通知"),
    PAY_QUERY("PAY_QUERY", "支付查询"),
    REFUND_APPLY("REFUND_APPLY", "退款申请"),
    REFUND_NOTIFY("REFUND_NOTIFY", "退款通知"),
    REFUND_QUERY("REFUND_QUERY", "退款查询"),
    CLOSE_ORDER("CLOSE_ORDER", "关闭订单");

    private String code;

    private String desc;

    PaymentFlowOperationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    public String getCode() {
        return code;
    }
    public String getDesc() {
        return desc;
    }
    public static PaymentFlowOperationTypeEnum getByCode(String code) {
        for (PaymentFlowOperationTypeEnum value : PaymentFlowOperationTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}

