/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class RedisBean {
    private static final Logger log = LoggerFactory.getLogger(RedisBean.class);
    @Autowired
    private RedisProperties redisProperties;

    @Bean(destroyMethod="shutdown")
    public RedissonClient redissonClient() {
        Config config = new Config();
        String redisUrl = String.format("redis://%s:%s", this.redisProperties.getHost() + "", this.redisProperties.getPort() + "");
        config.useSingleServer().setAddress(redisUrl).setPassword(this.redisProperties.getPassword());
        config.useSingleServer().setDatabase(this.redisProperties.getDatabase());
        config.useSingleServer().setConnectionPoolSize(this.redisProperties.getJedis().getPool().getMaxActive());
        config.useSingleServer().setIdleConnectionTimeout(60000);
        config.useSingleServer().setConnectTimeout(30000);
        config.useSingleServer().setTimeout(3000);
        log.info("RedissonClient create jedis");
        return Redisson.create((Config)config);
    }
}

