/**
 * @(#)RedisBean.java
 *
 * @author Challenger
 * @version 1.0 Oct 19, 2021
 *
 * Copyright (C) 2000,2021 , TeamSun, Inc.
 */
package com.bizvane.utils.redisutils;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class RedisBean {

  @Autowired
  private RedisProperties redisProperties;
  
  @Bean(destroyMethod = "shutdown")
  public RedissonClient redissonClient() {
    
    Config config = new Config();
    String redisUrl = String.format("redis://%s:%s", redisProperties.getHost() + "", redisProperties.getPort() + "");
    config.useSingleServer().setAddress(redisUrl).setPassword(redisProperties.getPassword());
    config.useSingleServer().setDatabase(redisProperties.getDatabase());

    //设置对于master节点的连接池中最大连接数
    config.useSingleServer().setConnectionPoolSize(redisProperties.getJedis().getPool().getMaxActive());
    
    //如果当前连接池里的连接数量超过了最小空闲连接数，而同时有连接空闲时间超过了该数值，那么这些连接将会自动被关闭，并从连接池里去掉。时间单位是毫秒。
    config.useSingleServer().setIdleConnectionTimeout(60000);
    
    //同任何节点建立连接时的等待超时。时间单位是毫秒。
    config.useSingleServer().setConnectTimeout(30000);
    
    //等待节点回复命令的时间。该时间从命令发送成功时开始计时。
    config.useSingleServer().setTimeout(3000);

    log.info("RedissonClient create jedis");
    return Redisson.create(config);
  }
}



/**
 * Revision history
 * -------------------------------------------------------------------------
 * 
 * Date Author Note
 * -------------------------------------------------------------------------
 * Oct 19, 2021 Challenger 创建版本
 */