package com.bizvane.utils.tokens;

import com.bizvane.utils.commonutils.FeignConfig;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @author lijunke
 */
@Aspect
@Component
public class RequestContextHolderWarpDelegate implements EnvironmentAware {

    Environment environment;

    @Before(value = "@annotation(tokenSupport)")
    public void doBefore(JoinPoint joinPoint, TokenSupport tokenSupport) {
        this.tokenBuffer(joinPoint, tokenSupport);
    }


    protected void tokenBuffer(JoinPoint joinPoint, TokenSupport tokenSupport) {
        Class clazz = joinPoint.getSignature().getDeclaringType();
        String methodName = joinPoint.getSignature().getName();
        StringBuffer stringBuffer = new StringBuffer();
        if (tokenSupport == null) {
            return;
        }
        synchronized (stringBuffer.append(clazz).append(methodName).toString()) {
            if (StringUtils.isNotBlank(tokenSupport.sysCompanyId())) {
                String sysCompanyIdValue = tokenSupport.sysCompanyId();
                if (StringUtils.containsAny(sysCompanyIdValue, '$', '{', '}')) {
                    sysCompanyIdValue = environment.resolvePlaceholders(sysCompanyIdValue);
                }
                Map<String, String> map = new ConcurrentHashMap(1);
                map.put(FeignConfig.BIZVANE_REQUEST_BUSINESS_ID, sysCompanyIdValue);
                TokenApplicationContext.setRequestAttributes(map, true);
            }
        }
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

}
