/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.Redisson;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonRedLock;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"spring.redis"})
@Component
public class RedissonTemplate {
    private static final Logger log = LoggerFactory.getLogger(RedissonTemplate.class);
    @Resource
    private RedissonClient redissonClient;
    @Autowired
    private RedisProperties redisProperties;

    @Bean(destroyMethod="shutdown")
    public RedissonClient redissonClient() {
        Config config = new Config();
        String redisUrl = String.format("redis://%s:%s", this.redisProperties.getHost() + "", this.redisProperties.getPort() + "");
        config.useSingleServer().setAddress(redisUrl).setPassword(this.redisProperties.getPassword());
        config.useSingleServer().setDatabase(this.redisProperties.getDatabase());
        return Redisson.create((Config)config);
    }

    public RLock getRLock(String key) {
        return this.redissonClient.getLock(key);
    }

    public void getRLook(String key) {
        this.redissonClient.getLock(key).lock();
    }

    public void getRUnLook(String key) {
        log.info("\u5f00\u59cb\u91ca\u653eredission\u5206\u5e03\u5f0f\u9501:" + key);
        RLock lock = this.redissonClient.getLock(key);
        if (lock.isLocked() && lock.isHeldByCurrentThread()) {
            log.info("excute");
            lock.unlock();
            log.info("success");
        }
    }

    public boolean isRLock(String key) {
        return this.redissonClient.getLock(key).isLocked();
    }

    public boolean isExistsRLock(String key) {
        return this.redissonClient.getLock(key).isExists();
    }

    public void getRLock(String key, long leaseTime, TimeUnit timeUnit) {
        this.redissonClient.getLock(key).lock(leaseTime, timeUnit);
    }

    public boolean tryRLock(String key, long tryLookWaitTime, long leaseTime) throws InterruptedException {
        RLock rLock = this.redissonClient.getLock(key);
        return rLock.tryLock(tryLookWaitTime, leaseTime, TimeUnit.SECONDS);
    }

    public void getRFairLock(String key) {
        this.redissonClient.getFairLock(key).lock();
    }

    public void getRFairUnLock(String key) {
        this.redissonClient.getFairLock(key).unlock();
    }

    public void getRFairLock(String key, long leaseTime) {
        this.redissonClient.getFairLock(key).lock(leaseTime, TimeUnit.SECONDS);
    }

    public boolean getRFairLook(String key, long tryLookWaitTime, long leaseTime) throws InterruptedException {
        return this.redissonClient.getFairLock(key).tryLock(tryLookWaitTime, leaseTime, TimeUnit.SECONDS);
    }

    public void multiLock(RLock ... rLocks) {
        new RedissonMultiLock(rLocks).lock();
    }

    public void multiLock(RLock[] rLocks, long waitTime) {
        new RedissonMultiLock(rLocks).lock(waitTime, TimeUnit.SECONDS);
    }

    public void multiUnLock(RLock ... rLocks) {
        new RedissonMultiLock(rLocks).unlock();
    }

    public boolean multiLock(RLock[] rLocks, long tryLookWaitTime, long leaseTime) throws InterruptedException {
        return new RedissonMultiLock(rLocks).tryLock(tryLookWaitTime, leaseTime, TimeUnit.SECONDS);
    }

    public void redLock(RLock ... rLocks) {
        new RedissonRedLock(rLocks).lock();
    }

    public void redLock(RLock[] rLocks, long waitTime) {
        new RedissonRedLock(rLocks).lock(waitTime, TimeUnit.SECONDS);
    }

    public void redUnLock(RLock ... rLocks) {
        new RedissonRedLock(rLocks).unlock();
    }

    public boolean redLock(RLock[] rLocks, long tryLookWaitTime, long leaseTime) throws InterruptedException {
        return new RedissonRedLock(rLocks).tryLock(tryLookWaitTime, leaseTime, TimeUnit.SECONDS);
    }

    public void readLock(String key) {
        this.redissonClient.getReadWriteLock(key).readLock().lock();
    }

    public void readLock(String key, long waitTime) {
        this.redissonClient.getReadWriteLock(key).readLock().lock(waitTime, TimeUnit.SECONDS);
    }

    public void readUnLock(String key) {
        this.redissonClient.getReadWriteLock(key).readLock().unlock();
    }

    public boolean readLock(String key, long tryLookWaitTime, long leaseTime) throws InterruptedException {
        return this.redissonClient.getReadWriteLock(key).readLock().tryLock(tryLookWaitTime, leaseTime, TimeUnit.SECONDS);
    }

    public void writeLock(String key) {
        this.redissonClient.getReadWriteLock(key).writeLock().lock();
    }

    public void writeUnLock(String key) {
        this.redissonClient.getReadWriteLock(key).writeLock().unlock();
    }

    public void writeLock(String key, long waitTime) {
        this.redissonClient.getReadWriteLock(key).writeLock().lock(waitTime, TimeUnit.SECONDS);
    }

    public boolean writeLock(String key, long tryLookWaitTime, long leaseTime) throws InterruptedException {
        return this.redissonClient.getReadWriteLock(key).writeLock().tryLock(tryLookWaitTime, leaseTime, TimeUnit.SECONDS);
    }

    public void semaphoreTrySetPermits(String key, int permits) {
        this.redissonClient.getSemaphore(key).trySetPermits(permits);
    }

    public void semaphoreAcquire(String key) throws InterruptedException {
        this.redissonClient.getSemaphore(key).acquire();
    }

    public void semaphoreRelease(String key) {
        this.redissonClient.getSemaphore(key).release();
    }

    public void getPermitExpirableSemaphoreAddPermits(String key, int permits) {
        this.redissonClient.getPermitExpirableSemaphore(key).addPermits(permits);
    }

    public String getPermitExpirableSemaphoreAcquire(String key, long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        return this.redissonClient.getPermitExpirableSemaphore(key).acquire(leaseTime, timeUnit);
    }

    public void permitExpirableSemaphoreRelease(String key, String permitId) {
        this.redissonClient.getPermitExpirableSemaphore(key).release(permitId);
    }

    public RCountDownLatch getCountDownLatch(String key) {
        return this.redissonClient.getCountDownLatch(key);
    }

    public void latchSetCount(String key, long count) {
        this.getCountDownLatch(key).trySetCount(count);
    }

    public void await(String key) throws InterruptedException {
        this.getCountDownLatch(key).await();
    }

    public void latchCountDown(String key) {
        this.getCountDownLatch(key).countDown();
    }
}

