/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.cache.guava;

import com.bizvane.utils.cache.guava.GuavaContext;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cache.guava.maximumSize"})
@Component
public class GuavaCache<T> {
    private static final Logger log = LoggerFactory.getLogger(GuavaCache.class);
    @Autowired
    private GuavaContext<T> context;
    private LoadingCache<String, T> loadingCache;
    @Value(value="${cache.guava.maximumSize}")
    private Integer permitsPerSecond;

    @PostConstruct
    public void init() {
        this.loadingCache = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterWrite(2L, TimeUnit.MINUTES).initialCapacity(0).maximumSize((long)this.permitsPerSecond.intValue()).recordStats().removalListener((RemovalListener)new RemovalListener<String, Object>(){

            public void onRemoval(RemovalNotification<String, Object> notification) {
                GuavaCache.this.context.getType(((String)notification.getKey()).split(":")[0]).removal(((String)notification.getKey()).split(":")[1]);
            }
        }).build(new CacheLoader<String, T>(){

            public T load(String key) throws Exception {
                return GuavaCache.this.context.getType(key.split(":")[0]).load(key.split(":")[1]);
            }
        });
    }

    public T get(String key) {
        try {
            return (T)this.loadingCache.get((Object)key);
        }
        catch (ExecutionException e) {
            log.error("loadingCache:", (Throwable)e);
            return null;
        }
    }
}

