/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.tokens;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"jwt.signature"})
@Component
public class JWTUtil {
    @Value(value="${jwt.signature}")
    private String signature = "bizvane";
    private static final String SIGN = "bizvane";
    private static final String EXP = "exp";
    private static final String PAYLOAD = "payload";
    public static final String ISSUER = "bizvane";
    public static final String ID = "centercontrol";
    public static final String SUBJECT = "loginToken";
    public static final Integer TTLMILLIS = 18000000;

    public <T> String sign2(T object, long maxAge) {
        try {
            JWTSigner signer = new JWTSigner(this.signature);
            HashMap<String, Object> claims = new HashMap<String, Object>();
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(object);
            claims.put(PAYLOAD, jsonString);
            claims.put(EXP, System.currentTimeMillis() + maxAge);
            return signer.sign(claims);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T unsign2(String jwt, Class<T> classT) {
        JWTVerifier verifier = new JWTVerifier(this.signature);
        try {
            long currentTimeMillis;
            long exp;
            Map claims = verifier.verify(jwt);
            if (claims.containsKey(EXP) && claims.containsKey(PAYLOAD) && (exp = ((Long)claims.get(EXP)).longValue()) > (currentTimeMillis = System.currentTimeMillis())) {
                String json = (String)claims.get(PAYLOAD);
                return (T)JSONObject.parseObject((String)json, classT);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> String sign(T object, long maxAge) {
        try {
            JWTSigner signer = new JWTSigner("bizvane");
            HashMap<String, Object> claims = new HashMap<String, Object>();
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(object);
            claims.put(PAYLOAD, jsonString);
            claims.put(EXP, System.currentTimeMillis() + maxAge);
            return signer.sign(claims);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T unsign(String jwt, Class<T> classT) {
        JWTVerifier verifier = new JWTVerifier("bizvane");
        try {
            long currentTimeMillis;
            long exp;
            Map claims = verifier.verify(jwt);
            if (claims.containsKey(EXP) && claims.containsKey(PAYLOAD) && (exp = ((Long)claims.get(EXP)).longValue()) > (currentTimeMillis = System.currentTimeMillis())) {
                String json = (String)claims.get(PAYLOAD);
                return (T)JSONObject.parseObject((String)json, classT);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createJWT(String playload) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)"bizvane");
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setPayload(playload).signWith(signatureAlgorithm, (Key)signingKey);
        return builder.compact();
    }

    public static String createJWT(String id, String issuer, String subject, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)"bizvane");
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(now).setSubject(subject).setIssuer(issuer).signWith(signatureAlgorithm, (Key)signingKey);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwt) {
        JwsHeader claims1 = (JwsHeader)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)"bizvane")).parseClaimsJws(jwt).getHeader();
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)"bizvane")).parseClaimsJws(jwt).getBody();
        System.out.println("ID: " + claims.getId());
        System.out.println("Subject: " + claims.getSubject());
        System.out.println("Issuer: " + claims.getIssuer());
        System.out.println("Expiration: " + claims.getExpiration());
        return claims;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWTUtil)) {
            return false;
        }
        JWTUtil other = (JWTUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JWTUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public String toString() {
        return "JWTUtil(signature=" + this.getSignature() + ")";
    }
}

