package com.bizvane.utils.tokens;

import com.bizvane.utils.commonutils.FeignConfig;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @author lijunke
 */
@Aspect
@Component
public class RequestContextHolderWarpDelegate {

    public static final Logger log = LoggerFactory.getLogger(RequestContextHolderWarpDelegate.class);

//    public static final String or = "||";
//    public static final String basePlatform = "execution(public * com.bizvane.basePlatform.rpc..*.*(..))";
//    public static final String customized = "execution(public * com.bizvane.customized.company..*.*(..))";
//
//
//    @Pointcut(basePlatform + or + customized)
//    public void aspect() {
//    }
//
//
//    @Before("aspect()")
//    public void doBefore(JoinPoint joinPoint) {
//        this.tokenBuffer(joinPoint);
//    }



    @Around(value = "@annotation(tokenSupport)")
    public void doAround(JoinPoint joinPoint,TokenSupport tokenSupport) {
        this.tokenBuffer(joinPoint,tokenSupport);
    }



    protected void tokenBuffer(JoinPoint joinPoint,TokenSupport tokenSupport) {
        Class clazz = joinPoint.getSignature().getDeclaringType();
        String methodName =  joinPoint.getSignature().getName();
        StringBuffer stringBuffer = new StringBuffer();
        if (tokenSupport == null) {
            return;
        }
        synchronized (stringBuffer.append(clazz).append(methodName).toString()) {
            if (StringUtils.isNotBlank(tokenSupport.sysCompanyId())) {
                String sysCompanyId = tokenSupport.sysCompanyId();

                Map<String, String> map = new ConcurrentHashMap(1);
                map.put(FeignConfig.BIZVANE_REQUEST_BUSINESS_ID, sysCompanyId);
                TokenApplicationContext.setRequestAttributes(map, true);
            }
        }
    }
}
