package com.bizvane.utils.huaweiutils;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.obs.services.ObsClient;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author chen.li
 * @date on 2019/11/22 9:50
 * @description 认证鉴权工具
 */
public class AuthorizationUtil {

    private static Map<String, String> appSecretkey = new HashMap<>();
    public static final String MAC_ALGORITHM_DEFAULT = "HmacSHA1";

    private static AuthTypeEnum authType = AuthTypeEnum.OBS;

    /**
     * 字符转换为对应的 UTF-8编码
     * @param s
     * @return E69CA8
     */
    public static String convertStringToUTF8(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            char c;
            for (int i = 0; i < s.length(); i++) {
                c = s.charAt(i);
                if (c >= 0 && c <= 255) {
                    sb.append(c);
                } else {
                    byte[] b;
                    b = Character.toString(c).getBytes("utf-8");
                    for (int j = 0; j < b.length; j++) {
                        int k = b[j];
                        //转换为unsigned integer  无符号integer
					/*if (k < 0)
						k += 256;*/
                        k = k < 0? k+256:k;
                        //返回整数参数的字符串表示形式 作为十六进制（base16）中的无符号整数
                        //该值以十六进制（base16）转换为ASCII数字的字符串
                        sb.append(Integer.toHexString(k).toUpperCase());

                        // url转置形式
                        // sb.append("%" +Integer.toHexString(k).toUpperCase());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    /**
     * 对消息进行hamcsha1签名
     * @param sk 签名密钥
     * @param stringToSign 签名内容
     * @return
     */
    public static String getSignature(String sk, String stringToSign ) {
        return hamcsha1(stringToSign.getBytes(), sk.getBytes());
    }

    /**
     * 获取基于哈希的消息验证代码
     * @param data 消息内容字节数组
     * @param key 签名密钥字节数组
     * @return
     */
    private static String hamcsha1(byte[] data, byte[] key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, MAC_ALGORITHM_DEFAULT);
            Mac mac = Mac.getInstance(MAC_ALGORITHM_DEFAULT);
            mac.init(signingKey);
            return byte2hex(mac.doFinal(data));
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 字节数组转16进制
     * @param b 字节数组
     * @return
     */
    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp;
        for (int n = 0; b != null && n < b.length; n++) {
            stmp = Integer.toHexString(b[n] & 0XFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    /**
     * 接受方校验签名
     * @param appId 应用唯一标识
     * @param signatrue 签名结果
     * @param msg 消息内容
     * @return
     */
    public static boolean verifySignature(String appId, String signatrue, String msg) {
        String secretKey = appSecretkey.get(appId);
        if (StringUtils.isBlank(secretKey)) {
            return false;
        }
        String checkSignatrue = hamcsha1(msg.getBytes(), secretKey.getBytes());
        return checkSignatrue.equals(checkSignatrue);
    }
}
