package com.bizvane.utils.tokens;

import com.bizvane.utils.commonutils.FeignConfig;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @author lijunke
 */
@Aspect
@Component
public class RequestContextHolderWarpDelegate {

    public static final Logger log = LoggerFactory.getLogger(RequestContextHolderWarpDelegate.class);

    public static final String or = "||";
    public static final String basePlatform = "execution(public * com.bizvane.basePlatform.rpc..*.*(..))";
    public static final String customized = "execution(public * com.bizvane.customized.company..*.*(..))";


//    @Pointcut(basePlatform + or + customized)
//    public void aspect() {
//    }


//
//    @Before("aspect()")
//    public void doBefore(JoinPoint joinPoint) {
//        this.tokenBuffer(joinPoint);
//    }

//
//    @Pointcut(value = "@annotation(tokenSupport)")
//    public void pointCut(TokenSupport tokenSupport){}



    @Around("@annotation(tokenSupport)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, TokenSupport tokenSupport) throws Throwable {
        tokenBuffer(proceedingJoinPoint);
        return proceedingJoinPoint.proceed();
    }

    @AfterThrowing(pointcut = "@annotation(tokenSupport)", throwing = "error")
    public void afterThrowing (Throwable  error, TokenSupport tokenSupport){
        log.error(error.getMessage());
    }

    protected void tokenBuffer(JoinPoint joinPoint) {
        Class clazz = joinPoint.getSignature().getDeclaringType();

        TokenSupport tokenSupport = AnnotationUtils.findAnnotation(clazz, TokenSupport.class);
        if (tokenSupport == null) {
            return;
        }
        synchronized (clazz) {
            if (StringUtils.isNotBlank(tokenSupport.sysCompanyId())) {
                Map<String, String> map = new ConcurrentHashMap(1);
                map.put(FeignConfig.BIZVANE_REQUEST_BUSINESS_ID, tokenSupport.sysCompanyId());
                TokenApplicationContext.setRequestAttributes(map, true);
            }
        }
    }
}
