package com.bizvane.utils.tokens;

import com.bizvane.utils.commonutils.FeignConfig;
import lombok.extern.java.Log;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @author lijunke
 */
@Aspect
@Component
@Log
public class RequestContextHolderWarpDelegate {

    public static final String or = "||";
    public static final String basePlatform = "execution(public * com.bizvane.basePlatform.rpc..*.*(..))";
    public static final String customized = "execution(public * com.bizvane.customized.company..*.*(..))";



    @Pointcut(basePlatform + or + customized)
    public void aspect() {
    }


    @Before("aspect()")
    public void doBefore(JoinPoint joinPoint) {
        this.tokenBuffer(joinPoint);
    }

    protected void tokenBuffer(JoinPoint joinPoint) {
        Class clazz = joinPoint.getSignature().getDeclaringType();
        Method[] methods = joinPoint.getSignature().getDeclaringType().getDeclaredMethods();

        TokenSupport tokenSupport = AnnotationUtils.findAnnotation(clazz, TokenSupport.class);
        if(tokenSupport == null) {
            return;
        }
        synchronized (clazz) {
            if (StringUtils.isNotBlank(tokenSupport.sysCompanyId())) {
                Map<String, String> map = new ConcurrentHashMap(1);
                map.put(FeignConfig.BIZVANE_REQUEST_BUSINESS_ID, tokenSupport.sysCompanyId());
                TokenApplicationContext.setRequestAttributes(map, true);
            }
        }
    }
}
