package com.bizvane.utils.tokens;

import com.bizvane.utils.commonutils.FeignConfig;
import lombok.extern.java.Log;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @author lijunke
 */
@Aspect
@Component
@Log
public class RequestContextHolderWarpDelegate {

    private Object obj = new Object();

    @Pointcut("execution(public * com.bizvane.basePlatform.rpc..*.*(..))")
    public void aspect() {}


    @Before("aspect()")
    public void doBefore(JoinPoint joinPoint) {
        synchronized (obj) {
            Class clazz = joinPoint.getSignature().getDeclaringType();
            TokenSupport tokenSupport = AnnotationUtils.findAnnotation(clazz, TokenSupport.class);
            if (StringUtils.isNotBlank(tokenSupport.sysCompanyId())) {
                Map<String, String> map = new ConcurrentHashMap(1);
                map.put(FeignConfig.BIZVANE_REQUEST_BUSINESS_ID, tokenSupport.sysCompanyId());
                TokenApplicationContext.setRequestAttributes(map, true);
            }
        }
    }
}
