package com.bizvane.utils.commonutils;

import feign.InvocationHandlerFactory;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Target;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * @author lijunke
 */
@Configuration
public class FeignConfig implements RequestInterceptor, InvocationHandlerFactory {
    @Override
    public InvocationHandler create(Target target, Map<Method, MethodHandler> map) {
        System.out.println();
        return null;
    }



    public static final String BIZVANE_REQUEST_BUSINESS_ID = "bizvane-request-business-id";

    @Override
    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration<String> headerNames = request.getHeaderNames();
            if (headerNames != null) {
                String name, values;
                while (headerNames.hasMoreElements()) {
                    name = headerNames.nextElement();
                    if ("content-type".equals(name.toLowerCase())) {
                        continue;
                    }
                    values = request.getHeader(name);
                    requestTemplate.header(name, values);
                }
            }
        }

        Map<String, String> headers = getHeaders(getHttpServletRequest());
        if (null == headers || !headers.keySet().contains(BIZVANE_REQUEST_BUSINESS_ID) || StringUtils.isEmpty(headers.get(BIZVANE_REQUEST_BUSINESS_ID))) {
            requestTemplate.header(BIZVANE_REQUEST_BUSINESS_ID , "1321");
        }

    }



    private HttpServletRequest getHttpServletRequest() {
        try {
            return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        } catch (Exception e) {
            return null;
        }
    }

    private Map<String, String> getHeaders(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> map = new LinkedHashMap<>();
        Enumeration<String> enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toLowerCase();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }


}
