/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.commonutils;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignConfig
implements RequestInterceptor {
    public static final String BIZVANE_REQUEST_BUSINESS_ID = "bizvane-request-business-id";

    public void apply(RequestTemplate requestTemplate) {
        Map<String, String> headers;
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if ("content-type".equals(name.toLowerCase())) continue;
                String values = request.getHeader(name);
                requestTemplate.header(name, new String[]{values});
            }
        }
        if (null == (headers = this.getHeaders(this.getHttpServletRequest())) || !headers.keySet().contains(BIZVANE_REQUEST_BUSINESS_ID) || StringUtils.isEmpty((CharSequence)headers.get(BIZVANE_REQUEST_BUSINESS_ID))) {
            requestTemplate.header(BIZVANE_REQUEST_BUSINESS_ID, new String[]{"1321"});
        }
    }

    private HttpServletRequest getHttpServletRequest() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, String> getHeaders(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = ((String)enumeration.nextElement()).toLowerCase();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }
}

