/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import com.bizvane.utils.redisutils.RedisTemplateService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Service;

@Service(value="redisTemplateService")
public class RedisTemplateServiceImpl<K, V>
implements RedisTemplateService<K, V> {
    Logger logger = LoggerFactory.getLogger(RedisTemplateService.class);
    @Autowired
    private RedisTemplate<K, V> redisTemplate;

    public RedisTemplateServiceImpl(RedisTemplate<K, V> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void deleteFromRedis(K key) {
        this.redisTemplate.delete(key);
    }

    @Override
    public <HK> Boolean hashCheckHxists(K hKey, HK field) {
        return this.redisTemplate.opsForHash().hasKey(hKey, field);
    }

    @Override
    public <HK> V hashGet(K hKey, HK hashKey) {
        return (V)this.redisTemplate.opsForHash().get(hKey, hashKey);
    }

    @Override
    public Map<K, V> hashGetAll(K key) {
        return this.redisTemplate.opsForHash().entries(key);
    }

    @Override
    public <HK> Long hashIncrementLongOfHashMap(K hKey, HK hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment(hKey, hashKey, delta.longValue());
    }

    @Override
    public <HK> Double hashIncrementDoubleOfHashMap(K hKey, HK hashKey, Double delta) {
        return this.redisTemplate.opsForHash().increment(hKey, hashKey, delta.doubleValue());
    }

    @Override
    public <HK> void hashPushHashMap(K key, HK hashKey, V value) {
        this.redisTemplate.opsForHash().put(key, hashKey, value);
    }

    @Override
    public Set<V> hashGetAllHashKey(K key) {
        return this.redisTemplate.opsForHash().keys(key);
    }

    @Override
    public Long hashGetHashMapSize(K key) {
        return this.redisTemplate.opsForHash().size(key);
    }

    @Override
    public List<V> hashGetHashAllValues(K key) {
        return this.redisTemplate.opsForHash().values(key);
    }

    @Override
    public <HK> Long hashDeleteHashKey(K key, HK ... hashKeys) {
        return this.redisTemplate.opsForHash().delete(key, (Object[])hashKeys);
    }

    @Override
    public void listLeftPushList(K key, V value) {
        this.redisTemplate.opsForList().leftPush(key, value);
    }

    @Override
    public V listLeftPopList(K key) {
        return (V)this.redisTemplate.opsForList().leftPop(key);
    }

    @Override
    public Long listSize(K key) {
        return this.redisTemplate.opsForList().size(key);
    }

    @Override
    public List<V> listRangeList(K key, Long start, Long end) {
        return this.redisTemplate.opsForList().range(key, start.longValue(), end.longValue());
    }

    @Override
    public Long listRemoveFromList(K key, long i, V value) {
        return this.redisTemplate.opsForList().remove(key, i, value);
    }

    @Override
    public V listIndexFromList(K key, long index) {
        return (V)this.redisTemplate.opsForList().index(key, index);
    }

    @Override
    public void listSetValueToList(K key, long index, V value) {
        this.redisTemplate.opsForList().set(key, index, value);
    }

    @Override
    public void listTrimByRange(K key, Long start, Long end) {
        this.redisTemplate.opsForList().trim(key, start.longValue(), end.longValue());
    }

    @Override
    public void listRightPushList(K key, V value) {
        this.redisTemplate.opsForList().rightPush(key, value);
    }

    @Override
    public V listRightPopList(K key) {
        return (V)this.redisTemplate.opsForList().rightPop(key);
    }

    @Override
    public Long setAddSetMap(K key, V ... values) {
        return this.redisTemplate.opsForSet().add(key, (Object[])values);
    }

    @Override
    public Long setGetSizeForSetMap(K key) {
        return this.redisTemplate.opsForSet().size(key);
    }

    @Override
    public Set<V> setGetMemberOfSetMap(K key) {
        return this.redisTemplate.opsForSet().members(key);
    }

    @Override
    public Boolean setCheckIsMemberOfSet(K key, V o) {
        return this.redisTemplate.opsForSet().isMember(key, o);
    }

    @Override
    public Integer stringAppendString(K key, String value) {
        return this.redisTemplate.opsForValue().append(key, value);
    }

    @Override
    public V stringGetStringByKey(K key) {
        return (V)this.redisTemplate.opsForValue().get(key);
    }

    @Override
    public String stringGetSubStringFromString(K key, long start, long end) {
        return this.redisTemplate.opsForValue().get(key, start, end);
    }

    @Override
    public Long stringIncrementLongString(K key, Long delta) {
        return this.redisTemplate.opsForValue().increment(key, delta.longValue());
    }

    @Override
    public Long stringIncrementLongString(K key, Long delta, Long timeout) {
        return null;
    }

    @Override
    public Double stringIncrementDoubleString(K key, Double delta) {
        return this.redisTemplate.opsForValue().increment(key, delta.doubleValue());
    }

    @Override
    public void stringSetString(K key, V value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    @Override
    public V stringGetAndSet(K key, V value) {
        return (V)this.redisTemplate.opsForValue().getAndSet(key, value);
    }

    @Override
    public void stringSetValueAndExpireTime(K key, V value, long timeout) {
        this.redisTemplate.opsForValue().set(key, value, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Long incr(String key, long liveTime) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        Long increment = entityIdCounter.getAndIncrement();
        if ((null == increment || increment == 0L) && liveTime > 0L) {
            entityIdCounter.expire(liveTime, TimeUnit.SECONDS);
        }
        return increment;
    }

    @Override
    public long getIncrValue(String key) {
        return (Long)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            byte[] rowkey = serializer.serialize((Object)key);
            byte[] rowval = connection.get(rowkey);
            try {
                String val = (String)serializer.deserialize(rowval);
                return Long.parseLong(val);
            }
            catch (Exception e) {
                return 0L;
            }
        });
    }

    @Override
    public boolean setIfAbsent(K key, V value) {
        return this.redisTemplate.opsForValue().setIfAbsent(key, value);
    }

    @Override
    public void redisForListSetExpire(K key, V value, Long expire, TimeUnit timeUnit) {
        try {
            Long line = this.redisTemplate.opsForList().leftPushAll(key, new Object[]{value});
            boolean flag = this.redisTemplate.expire(key, expire.longValue(), timeUnit);
            this.logger.info("redis for list set data:{}, set expire time :{}", (Object)line, (Object)flag);
        }
        catch (Exception e) {
            this.logger.error("\u64cd\u4f5credis\u5931\u8d25\uff01" + e);
        }
    }

    @Override
    public Boolean hasKey(K key) {
        return this.redisTemplate.hasKey(key);
    }

    @Override
    public List<V> getListRange(K key, Long start, Long end) {
        return this.redisTemplate.opsForList().range(key, start.longValue(), end.longValue());
    }
}

