/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.huaweiutils;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.obs.services.model.AuthTypeEnum;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthorizationUtil {
    private static Map<String, String> appSecretkey = new HashMap<String, String>();
    public static final String MAC_ALGORITHM_DEFAULT = "HmacSHA1";
    private static AuthTypeEnum authType = AuthTypeEnum.OBS;

    public static String convertStringToUTF8(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= '\u0000' && c <= '\u00ff') {
                    sb.append(c);
                    continue;
                }
                byte[] b = Character.toString(c).getBytes("utf-8");
                for (int j = 0; j < b.length; ++j) {
                    int k = b[j];
                    k = k < 0 ? k + 256 : k;
                    sb.append(Integer.toHexString(k).toUpperCase());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getSignature(String sk, String stringToSign) {
        return AuthorizationUtil.hamcsha1(stringToSign.getBytes(), sk.getBytes());
    }

    private static String hamcsha1(byte[] data, byte[] key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, MAC_ALGORITHM_DEFAULT);
            Mac mac = Mac.getInstance(MAC_ALGORITHM_DEFAULT);
            mac.init(signingKey);
            return AuthorizationUtil.byte2hex(mac.doFinal(data));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static boolean verifySignature(String appId, String signatrue, String msg) {
        String secretKey = appSecretkey.get(appId);
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            return false;
        }
        String checkSignatrue = AuthorizationUtil.hamcsha1(msg.getBytes(), secretKey.getBytes());
        return checkSignatrue.equals(checkSignatrue);
    }
}

