/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.commonutils;

import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.codec.Decoder;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignConfig
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if ("content-type".equals(name.toLowerCase())) continue;
                String values = request.getHeader(name);
                requestTemplate.header(name, new String[]{values});
            }
        }
    }

    @Bean
    public Decoder feignDecoder() {
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(this.feignHttpMessageConverter()));
    }

    public ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{new PhpMappingJackson2HttpMessageConverter()});
        return () -> httpMessageConverters;
    }

    public class PhpMappingJackson2HttpMessageConverter
    extends MappingJackson2HttpMessageConverter {
        PhpMappingJackson2HttpMessageConverter() {
            FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(MediaType.valueOf((String)"text/html;charset=UTF-8"));
            mediaTypes.add(MediaType.APPLICATION_JSON);
            mediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
            mediaTypes.add(MediaType.APPLICATION_ATOM_XML);
            mediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
            mediaTypes.add(MediaType.APPLICATION_OCTET_STREAM);
            mediaTypes.add(MediaType.APPLICATION_PDF);
            mediaTypes.add(MediaType.APPLICATION_RSS_XML);
            mediaTypes.add(MediaType.APPLICATION_XHTML_XML);
            mediaTypes.add(MediaType.APPLICATION_XML);
            mediaTypes.add(MediaType.IMAGE_GIF);
            mediaTypes.add(MediaType.IMAGE_JPEG);
            mediaTypes.add(MediaType.IMAGE_PNG);
            mediaTypes.add(MediaType.TEXT_EVENT_STREAM);
            mediaTypes.add(MediaType.TEXT_HTML);
            mediaTypes.add(MediaType.TEXT_MARKDOWN);
            mediaTypes.add(MediaType.TEXT_PLAIN);
            mediaTypes.add(MediaType.TEXT_XML);
            fastConverter.setSupportedMediaTypes(mediaTypes);
            this.setSupportedMediaTypes(mediaTypes);
        }
    }
}

