/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.commonutils;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignConfig
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignConfig.class);

    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                log.info("FeignConfig#apply name:{}", (Object)name);
                if ("content-type".equals(name.toLowerCase())) continue;
                String values = request.getHeader(name);
                log.info("FeignConfig#apply values:{}", (Object)values);
                requestTemplate.header(name, new String[]{values});
            }
        }
    }
}

