/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.commonutils;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignConfig
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignConfig.class);

    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            Enumeration bodyNames;
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    log.info("FeignConfig#apply name:{}", (Object)name);
                    String values = request.getHeader(name);
                    log.info("FeignConfig#apply values:{}", (Object)values);
                    requestTemplate.header(name, new String[]{values});
                }
            }
            if ((bodyNames = request.getParameterNames()) != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                while (bodyNames.hasMoreElements()) {
                    String name = (String)bodyNames.nextElement();
                    String values = request.getParameter(name);
                    log.info("FeignConfig#apply body name:{},values:{}", (Object)name, (Object)values);
                    requestTemplate.query(name, new String[]{values});
                    map.put(name, values);
                }
            }
        }
    }
}

