/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.huaweiutils;

import com.alibaba.fastjson.JSON;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.PutObjectResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"huaweicloud.obs.domain"})
@Component
public class ObsUtil {
    private static final Logger log = LoggerFactory.getLogger(ObsUtil.class);
    @Value(value="${huaweicloud.obs.domain}")
    private String domain;
    @Value(value="${huaweicloud.obs.bucketName}")
    private String bucketName;
    @Value(value="${huaweicloud.obs.accessKey}")
    private String accessKey;
    @Value(value="${huaweicloud.obs.secretKey}")
    private String secretKey;
    private final String endPoint = "obs.cn-south-1.myhuaweicloud.com";

    public ObsClient getObsClient() {
        return new ObsClient(this.accessKey, this.secretKey, "obs.cn-south-1.myhuaweicloud.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String objectName, File file) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, file);
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream inputStream, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, inputStream);
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadUrl(String url, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, new URL(url).openStream());
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            log.error("ObsUtil#upload MalformedURLException error:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadRelativeUrl(String url, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, new URL(url).openStream());
            log.info("ObsUtil#upload putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult));
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = objectName;
            return string;
        }
        catch (ObsException e) {
            log.error("ObsUtil#upload ObsException error:{}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            log.error("ObsUtil#upload MalformedURLException error:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("ObsUtil#upload IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }
}

