/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;

@Configurable
@ConditionalOnBean(value={RedisTemplate.class})
public class RedisAutoConfiguration {
    @Order(value=1)
    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient(RedisTemplate redisTemplate) {
        return new RedisClient(redisTemplate);
    }

    @Order(value=1)
    @ConditionalOnBean(value={RedissonClient.class})
    @ConditionalOnMissingBean
    @Bean
    public RedissonTemplate redissonTemplate(RedissonClient redissonClient) {
        return new RedissonTemplate(redissonClient);
    }

    @Order(value=1)
    @Bean(value={"redisTemplateService"})
    @ConditionalOnMissingBean
    public RedisTemplateService<String, String> redisTemplateService(RedisTemplate redisTemplate) {
        return new RedisTemplateServiceImpl<String, String>(redisTemplate);
    }
}

