package com.bizvane.utils.redisutils;

import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * wang.zeyan
 */
@Configurable
@ConditionalOnBean(RedisTemplate.class)
public class RedisAutoConfiguration {

    @Order(1)
    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient(RedisTemplate redisTemplate) {
        return new RedisClient(redisTemplate);
    }

    @Order(1)
    @ConditionalOnBean(RedissonClient.class)
    @ConditionalOnMissingBean
    @Bean
    public RedissonTemplate redissonTemplate(RedissonClient redissonClient){
        return new RedissonTemplate(redissonClient);
    }

    @Order(1)
    @Bean("redisTemplateService")
    @ConditionalOnMissingBean
    public RedisTemplateService<String, String> redisTemplateService(RedisTemplate redisTemplate){
        return new RedisTemplateServiceImpl(redisTemplate);
    }
}
