package com.bizvane.utils.redisutils;

import java.io.Serializable;

import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * wang.zeyan
 */
@Configurable
@ConditionalOnBean(RedisTemplate.class)
public class RedisAutoConfigurationTemp {

    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient(RedisTemplate<Serializable, Object> redisTemplate) {
        return new RedisClient(redisTemplate);
    }

    @ConditionalOnBean(RedissonClient.class)
    @ConditionalOnMissingBean
    @Bean
    public RedissonTemplate redissonTemplate(RedissonClient redissonClient){
        return new RedissonTemplate(redissonClient);
    }

    @Bean("redisTemplateService")
    @ConditionalOnMissingBean
    public RedisTemplateService<Serializable, Object> redisTemplateService(RedisTemplate<Serializable, Object> redisTemplate){
        return new RedisTemplateServiceImpl<Serializable, Object>(redisTemplate);
    }
}
