/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.commonutils;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpUtil.class);
    private static final ThreadLocal<Exception> exception = new ThreadLocal();
    private static PoolingNHttpClientConnectionManager connMgr;
    private static ConnectingIOReactor ioReactor;
    private static int MAX_TIMEOUT;
    private static int MAX_POOL_COUNT;
    private static CloseableHttpAsyncClient httpClient;

    public static Exception hasException() {
        return exception.get();
    }

    public static String doGet(String url, String data) {
        return AsyncHttpUtil.doGet(url, new HashMap<String, Object>(), null, null);
    }

    public static String doGet(String url, Map<String, Object> params) {
        return AsyncHttpUtil.doGet(url, params, null, null);
    }

    public static String doGet(String url, FutureCallback<HttpResponse> futureCallback) {
        return AsyncHttpUtil.doGet(url, new HashMap<String, Object>(), futureCallback, null);
    }

    public static String doGet(String url, FutureCallback<HttpResponse> futureCallback, Map<String, String> headerParams) {
        return AsyncHttpUtil.doGet(url, new HashMap<String, Object>(), futureCallback, headerParams);
    }

    public static String doGet(String url, Map<String, Object> params, FutureCallback<HttpResponse> futureCallback, Map<String, String> headerParams) {
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                param.append("?");
            } else {
                param.append("&");
            }
            param.append(key).append("=").append(params.get(key));
            ++i;
        }
        apiUrl = apiUrl + param;
        String result = null;
        try {
            if (!httpClient.isRunning()) {
                httpClient.start();
            }
            HttpGet httpGet = new HttpGet(apiUrl);
            AsyncHttpUtil.handleHeader(headerParams, (HttpRequestBase)httpGet);
            Future future = httpClient.execute((HttpUriRequest)httpGet, futureCallback);
            if (futureCallback == null) {
                HttpResponse response = (HttpResponse)future.get(MAX_TIMEOUT, TimeUnit.MILLISECONDS);
                int statusCode = response.getStatusLine().getStatusCode();
                logger.info("====================statusCode:{}", (Object)statusCode);
                if (statusCode != 200) {
                    exception.set(new Exception("reqest error, status code:" + statusCode));
                    return null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
                }
            }
        }
        catch (Exception e) {
            logger.error("ERROR::", (Throwable)e);
            exception.set(e);
        }
        return result;
    }

    public static String doPost(String apiUrl, String jsonStr) {
        return AsyncHttpUtil.doPost(apiUrl, null, jsonStr, null, null, null);
    }

    public static String doPost(String apiUrl, String jsonStr, Map<String, Object> params) {
        return AsyncHttpUtil.doPost(apiUrl, null, jsonStr, params, null, null);
    }

    public static String doPost(String apiUrl, String jsonStr, FutureCallback<HttpResponse> futureCallback) {
        return AsyncHttpUtil.doPost(apiUrl, null, jsonStr, null, futureCallback, null);
    }

    public static String doPost(String apiUrl, String jsonStr, Map<String, Object> params, FutureCallback<HttpResponse> futureCallback) {
        return AsyncHttpUtil.doPost(apiUrl, null, jsonStr, params, futureCallback, null);
    }

    public static String doPost(String apiUrl, String jsonStr, FutureCallback<HttpResponse> futureCallback, Map<String, String> headerParams) {
        return AsyncHttpUtil.doPost(apiUrl, null, jsonStr, null, futureCallback, headerParams);
    }

    public static String doPost(String apiUrl, Map<String, Object> urlParam) {
        return AsyncHttpUtil.doPost(apiUrl, urlParam, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, Map<String, Object> urlParam, String jsonStr, Map<String, Object> params, FutureCallback<HttpResponse> futureCallback, Map<String, String> headerParams) {
        StringBuffer param = new StringBuffer();
        int i = 0;
        if (urlParam != null) {
            for (String key : urlParam.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(urlParam.get(key));
                ++i;
            }
        }
        apiUrl = apiUrl + param;
        String httpStr = null;
        try {
            BasicNameValuePair pair;
            if (!httpClient.isRunning()) {
                httpClient.start();
            }
            HttpPost httpPost = new HttpPost(apiUrl);
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                StringEntity stringEntity = new StringEntity(jsonStr, "UTF-8");
                stringEntity.setContentEncoding("UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            AsyncHttpUtil.handleHeader(headerParams, (HttpRequestBase)httpPost);
            Future future = httpClient.execute((HttpUriRequest)httpPost, futureCallback);
            if (futureCallback != null) return httpStr;
            HttpResponse response = (HttpResponse)future.get(MAX_TIMEOUT, TimeUnit.MILLISECONDS);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                logger.info("====================statusCode:{}", (Object)statusCode);
                if (statusCode != 200) {
                    exception.set(new Exception("reqest error, status code:" + statusCode));
                    pair = null;
                    return pair;
                }
                HttpEntity entity = response.getEntity();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            return httpStr;
        }
        catch (Exception e) {
            logger.error("ERROR::", (Throwable)e);
            exception.set(e);
        }
        return httpStr;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (Exception e) {
            logger.error("ERROR::", (Throwable)e);
        }
        return sc;
    }

    private static HostnameVerifier createHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    private static void handleHeader(Map<String, String> headerParams, HttpRequestBase request) {
        if (headerParams != null && headerParams.size() > 0) {
            for (String key : headerParams.keySet()) {
                request.addHeader(key, headerParams.get(key));
            }
        }
    }

    static {
        MAX_TIMEOUT = 30000;
        MAX_POOL_COUNT = 100;
        try {
            MAX_TIMEOUT = 120000;
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            Registry sessionStrategyRegistry = registryBuilder.register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(AsyncHttpUtil.createIgnoreVerifySSL(), AsyncHttpUtil.createHostnameVerifier())).build();
            IOReactorConfig config = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setConnectTimeout(MAX_TIMEOUT).setSoTimeout(MAX_TIMEOUT).build();
            ioReactor = new DefaultConnectingIOReactor(config);
            connMgr = new PoolingNHttpClientConnectionManager(ioReactor, null, sessionStrategyRegistry, null);
            connMgr.setMaxTotal(MAX_POOL_COUNT);
            connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
            httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)connMgr).build();
            System.setProperty("jsse.enableSNIExtension", "false");
        }
        catch (IOReactorException e) {
            logger.error("ERROR::", (Throwable)e);
        }
    }
}

