/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.huaweiutils;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.PutObjectResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"huaweicloud.obs.domain"})
@Component
public class ObsUtil {
    @Value(value="${huaweicloud.obs.domain}")
    private String domain;
    @Value(value="${huaweicloud.obs.bucketName}")
    private String bucketName;
    @Value(value="${huaweicloud.obs.accessKey}")
    private String accessKey;
    @Value(value="${huaweicloud.obs.secretKey}")
    private String secretKey;

    public ObsClient getObsClient() {
        return new ObsClient(this.accessKey, this.secretKey, this.domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream inputStream, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, inputStream);
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException obsException) {
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadUrl(String url, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, new URL(url).openStream());
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = this.domain + "/" + objectName;
            return string;
        }
        catch (ObsException obsException) {
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadRelativeUrl(String url, String objectName) {
        ObsClient obsClient = null;
        try {
            obsClient = this.getObsClient();
            PutObjectResult putObjectResult = obsClient.putObject(this.bucketName, objectName, new URL(url).openStream());
            obsClient.setObjectAcl(this.bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
            String string = objectName;
            return string;
        }
        catch (ObsException obsException) {
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

