/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.mongoutils;

import com.bizvane.utils.mongoutils.MongoTemplateService;
import com.bizvane.utils.responseinfo.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;

public class MongoTemplateServiceImpl<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements MongoTemplateService<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(MongoTemplateServiceImpl.class);
    protected final MongoOperations mongoTemplate;
    @Autowired
    protected final MongoEntityInformation<T, ID> entityInformation;
    private Class<T> clazz;

    public MongoTemplateServiceImpl(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.mongoTemplate = mongoOperations;
        this.entityInformation = metadata;
        this.clazz = this.entityInformation.getJavaType();
    }

    @Override
    public boolean singleSave(T t) {
        if (null != t) {
            try {
                this.save(t);
                return true;
            }
            catch (Exception ex) {
                logger.error("\u5355\u6761\u6dfb\u52a0MongoDB\u5931\u8d25\uff1a\u5165\u53c2:{}", t, (Object)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public <S extends T> int batchSave(List<S> list) {
        if (CollectionUtils.isNotEmpty(list) && (list = list.stream().filter(o -> Objects.nonNull(o)).collect(Collectors.toList())).size() > 0) {
            try {
                return this.saveAll(list).size();
            }
            catch (Exception ex) {
                logger.error("\u6279\u91cf\u6dfb\u52a0MongoDB\u5931\u8d25\uff1a\u5165\u53c2:{}", list, (Object)ex);
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean singleDelete(ID id) {
        if (id != null) {
            try {
                this.deleteById(id);
                return true;
            }
            catch (Exception ex) {
                logger.error("\u5355\u6761\u5220\u9664MongoDB\u5931\u8d25\uff1a\u5165\u53c2:{}", id, (Object)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean batchDelete(List<ID> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(list));
            try {
                this.mongoTemplate.findAllAndRemove(query, this.clazz);
                return true;
            }
            catch (Exception ex) {
                logger.error("\u6279\u91cf\u5220\u9664MongoDB\u5931\u8d25\uff1a\u5165\u53c2:{}", list, (Object)ex);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(ID id, Map<String, Object> updateMap) {
        if (updateMap != null || !updateMap.isEmpty()) {
            Criteria criteria = new Criteria("_id").is(id);
            Update update = new Update();
            updateMap.entrySet().forEach(entry -> update.set((String)entry.getKey(), entry.getValue()));
            try {
                this.mongoTemplate.findAndModify(new Query((CriteriaDefinition)criteria), update, this.clazz);
                boolean bl = true;
                return bl;
            }
            finally {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Map<String, Object> queryParam, Map<String, Object> updateField) {
        if (queryParam != null || !queryParam.isEmpty()) {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            for (Map.Entry<String, Object> entry2 : queryParam.entrySet()) {
                criteriaList.add(Criteria.where((String)entry2.getKey()).is(entry2.getValue()));
            }
            int size = criteriaList.size();
            Criteria[] criterias = new Criteria[size];
            for (int i = 0; i < size; ++i) {
                criterias[i] = (Criteria)criteriaList.get(i);
            }
            Criteria criteria = new Criteria().andOperator(criterias);
            if (updateField != null || !updateField.isEmpty()) {
                Update update = new Update();
                updateField.entrySet().forEach(entry -> update.set((String)entry.getKey(), entry.getValue()));
                try {
                    this.mongoTemplate.findAndModify(new Query((CriteriaDefinition)criteria), update, this.clazz);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public PageInfo<T> findPage(int pageIndex, int pageSize, Map<String, Integer> sort) {
        ArrayList orders = new ArrayList();
        PageRequest pageable = null;
        if (sort != null && !sort.isEmpty()) {
            sort.entrySet().forEach(entry -> orders.add(new Sort.Order((Integer)entry.getValue() == 0 ? Sort.Direction.ASC : Sort.Direction.DESC, (String)entry.getKey())));
            pageable = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)new Sort(orders));
        } else {
            pageable = PageRequest.of((int)pageIndex, (int)pageSize);
        }
        Page page = this.findAll((Pageable)pageable);
        PageInfo pageInfo = new PageInfo(pageIndex, pageSize);
        pageInfo.setList(page.getContent());
        pageInfo.setTotal((int)page.getTotalElements());
        pageInfo.setPages(page.getTotalPages());
        pageInfo.setSize(page.getContent().size());
        return pageInfo;
    }

    @Override
    public PageInfo<T> findPageWithParam(Map<String, Object> queryParam, Integer pageIndex, Integer pageSize, Map<String, Integer> sortParam) {
        if (queryParam == null || queryParam.isEmpty()) {
            return this.findPage(pageIndex, pageSize, sortParam);
        }
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (Map.Entry<String, Object> entry2 : queryParam.entrySet()) {
            criteriaList.add(Criteria.where((String)entry2.getKey()).is(entry2.getValue()));
        }
        Criteria[] criterias = new Criteria[criteriaList.size()];
        criterias = criteriaList.toArray(criterias);
        Criteria criteria = new Criteria().andOperator(criterias);
        Query query = new Query((CriteriaDefinition)criteria);
        if (sortParam != null && !sortParam.isEmpty()) {
            ArrayList orders = new ArrayList();
            sortParam.entrySet().forEach(entry -> orders.add(new Sort.Order((Integer)entry.getValue() == 0 ? Sort.Direction.ASC : Sort.Direction.DESC, (String)entry.getKey())));
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        long total = this.mongoTemplate.count(query, this.clazz);
        query.skip((long)(pageIndex * pageSize));
        query.limit(pageSize.intValue());
        List data = this.mongoTemplate.find(query, this.clazz);
        PageInfo pageInfo = new PageInfo(pageIndex, (int)pageSize);
        pageInfo.setTotal((int)total);
        pageInfo.setList(data);
        pageInfo.setSize(data.size());
        return pageInfo;
    }
}

